<?php
/**
 * This file is part of supermercado_solidario
 * Copyright (C) 2014-2021 Carlos Garcia Gomez <neorazorx@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Description of cliente2clan
 *
 * @author Carlos Garcia Gomez <neorazorx@gmail.com>
 */
class cliente2clan extends fs_model
{

    /**
     * 
     * @var string
     */
    public $codcliente;

    /**
     * 
     * @var string
     */
    public $codclan;

    /**
     * 
     * @param array $c
     */
    public function __construct($c = FALSE)
    {
        parent::__construct('cliente2clan', 'plugins/supermercado_solidario/');
        if ($c) {
            $this->codcliente = $c['codcliente'];
            $this->codclan = $c['codclan'];
        } else {
            $this->codcliente = NULL;
            $this->codclan = NULL;
        }
    }

    /**
     * 
     * @return string
     */
    protected function install()
    {
        return '';
    }

    /**
     * 
     * @param string $codcliente
     *
     * @return bool|clan_familiar
     */
    public function get_clan($codcliente)
    {
        $data = $this->db->select("SELECT * FROM " . $this->table_name .
            " WHERE codcliente = " . $this->var2str($codcliente) . ";");
        if ($data) {
            $clan = new clan_familiar();
            return $clan->get($data[0]['codclan']);
        }

        return FALSE;
    }

    /**
     * 
     * @return bool
     */
    public function exists()
    {
        if (is_null($this->codclan)) {
            return FALSE;
        }

        return $this->db->select("SELECT * FROM " . $this->table_name .
                " WHERE codclan = " . $this->var2str($this->codclan) .
                " AND codcliente = " . $this->var2str($this->codcliente) . ";");
    }

    /**
     * 
     * @return bool
     */
    public function test()
    {
        return TRUE;
    }

    /**
     * 
     * @return bool
     */
    public function save()
    {
        if ($this->test()) {
            if ($this->exists()) {
                $sql = "UPDATE " . $this->table_name . " SET codclan = " . $this->var2str($this->codclan) . "
               WHERE codcliente = " . $this->var2str($this->codcliente) . ";";
            } else {
                $sql = "INSERT INTO " . $this->table_name . " (codclan,codcliente)
               VALUES (" . $this->var2str($this->codclan) . "," . $this->var2str($this->codcliente) . ");";
            }
            return $this->db->exec($sql);
        }

        return FALSE;
    }

    /**
     * 
     * @return bool
     */
    public function delete()
    {
        return $this->db->exec("DELETE FROM " . $this->table_name . " WHERE codclan = " . $this->var2str($this->codclan) .
                " AND codcliente = " . $this->var2str($this->codcliente) . ";");
    }

    /**
     * 
     * @param string $cod
     *
     * @return array
     */
    public function all4clan($cod)
    {
        $clilist = array();
        $cliente = new cliente();

        $datos = $this->db->select("SELECT * FROM " . $this->table_name . " WHERE codclan = " . $this->var2str($cod) . ";");
        if ($datos) {
            foreach ($datos as $c)
                $clilist[] = $cliente->get($c['codcliente']);
        }

        return $clilist;
    }
}
